<?php
/*--------------------------------------------------------------
   routes.php 2021-09-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

use Gambio\Admin\Modules\Statistics\App\Overview\Action\AddWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\ConfigureWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\DeleteWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\GetAvailableWidgets;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\GetWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\GetWidgets;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\MoveWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\Overview;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\RenameWidget;
use Gambio\Admin\Modules\Statistics\App\Overview\Action\ResizeWidget;
use Gambio\Core\Application\Routing\RouteCollector;

return static function (RouteCollector $routeCollector) {
    $routeCollector->get('/admin/statistics/overview', Overview::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/{id}/delete',
                          DeleteWidget::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/add', AddWidget::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/{id}/configure',
                          ConfigureWidget::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/{id}/move',
                          MoveWidget::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/{id}/resize',
                          ResizeWidget::class);
    $routeCollector->get('/admin/api/statistics/overview/widgets', GetWidgets::class);
    $routeCollector->get('/admin/api/statistics/overview/widgets/{id}', GetWidget::class);
    $routeCollector->get('/admin/api/statistics/overview/available-widgets',
                         GetAvailableWidgets::class);
    $routeCollector->post('/admin/api/statistics/overview/widgets/{id}/rename',
                          RenameWidget::class);
};